local TABAS_ModOptions = {
    modID = "TakeABathAndShower",
    name = "Take A Bath And Shower",
    options = {
        RemoveAllTfc = nil,
        DisplaysAvailableShower = nil,
        DisplayTubWaterDirtyLevel = nil,
        WashOffMakeup = nil,
        NotTakeoff_Watches = nil,
        NotTakeOff_Accessories = nil,
        NotTakeOff_Belts = nil,
        AfterBathingDrySelf = nil,
        AutoClothesChange = nil,
        WearingActionTime = nil,
        DropEquippedItems = nil,
        DropEquippedItemsAll = nil,
        DropEquippedItemsBack = nil,
        DropEquippedItemsConatiner = nil,
        DropEquippedItemsAttached = nil,
        DropEquippedItemsHand = nil,
        DropEquippedItemsClothing = nil,
        DropEquippedItemsWeight = nil,
    }
}

local comboBox_WearingActionTime = {
    getText("UI_TABAS_WearingActionTime_Fast"),
    getText("UI_TABAS_WearingActionTime_Ones"),
    getText("UI_TABAS_WearingActionTime_Vanilla")
}

local function comboBoxAddItem(comboBox, list)
    comboBox:addItem(list[1], true)
    for i=2, #list do
        comboBox:addItem(list[i], false)
    end
end

local function removeAllTfcObject()
    if not GetTFCSystemData() then return end
    local TFC_Debug = require("TABAS_TubFluidContainerDebugMenu")
    TFC_Debug.clearAllTfc()
end


function TABAS_ModOptions:createOptions()
    local options = PZAPI.ModOptions:create(self.modID, self.name)
    self.options.RemoveAllTfc = options:addButton(
        "RemoveAllTfc",
        getText("UI_TABAS_RemoveAllTfc"),
        getText("UI_TABAS_RemoveAllTfc_tooltip"),
        removeAllTfcObject, nil
    )

    self.options.DisplaysAvailableShower = options:addTickBox(
        "DisplaysAvailableShower",
        getText("UI_TABAS_DisplaysAvailableShower"),
        true,
        getText("UI_TABAS_DisplaysAvailableShower_tooltip")
    )

    self.options.DisplayTubWaterDirtyLevel = options:addTickBox(
        "DisplayTubWaterDirtyLevel",
        getText("UI_TABAS_DisplayTubWaterDirtyLevel"),
        false,
        getText("UI_TABAS_DisplayTubWaterDirtyLevel_tooltip")
    )

    self.options.WashOffMakeup = options:addTickBox(
        "WashOffMakeup",
        getText("UI_TABAS_WashOffMakeup"),
        true,
        getText("UI_TABAS_WashOffMakeup_tooltip")
    )

    self.options.AfterBathingDrySelf = options:addTickBox(
        "AfterBathingDrySelf",
        getText("UI_TABAS_AfterBathingDrySelf"),
        true,
        getText("UI_TABAS_AfterBathingDrySelf_tooltip")
    )
    self.options.AutoClothesChange = options:addTickBox(
        "AutoClothesChange",
        getText("UI_TABAS_AutoClothesChange"),
        true,
        getText("UI_TABAS_AutoClothesChange_tooltip")
    )

    self.options.NotTakeoff_Watches = options:addTickBox(
        "NotTakeoff_Watches",
        getText("UI_TABAS_NotTakeoff_Watches"),
        false,
        getText("UI_TABAS_NotTakeoff_Watches_tooltip")
    )

    self.options.NotTakeOff_Accessories = options:addTickBox(
        "NotTakeOff_Accessories",
        getText("UI_TABAS_NotTakeOff_Accessories"),
        false,
        getText("UI_TABAS_NotTakeOff_Accessories_tooltip")
    )

    self.options.NotTakeOff_Belts = options:addTickBox(
        "NotTakeOff_Belts",
        getText("UI_TABAS_NotTakeOff_Belts"),
        false,
        getText("UI_TABAS_NotTakeOff_Belts_tooltip")
    )

    self.options.WearingActionTime = options:addComboBox(
        "WearingActionTime",
        getText("UI_TABAS_WearingActionTime"),
        getText("UI_TABAS_WearingActionTime_tooltip")
    )
    comboBoxAddItem(self.options.WearingActionTime, comboBox_WearingActionTime)

    options:addDescription(" ")
    options:addDescription("UI_TABAS_DropEquippedItems")
    options:addDescription("UI_TABAS_DropEquippedItems_tooltip")

    self.options.DropEquippedItemsAll = options:addTickBox(
        "DropEquippedItemsAll",
        getText("UI_TABAS_DropEquippedItemsAll"),
        false,
        getText("UI_TABAS_DropEquippedItemsAll_tooltip")
    )
    self.options.DropEquippedItemsBack = options:addTickBox(
        "DropEquippedItemsBack",
        getText("UI_TABAS_DropEquippedItemsBack"),
        true,
        getText("UI_TABAS_DropEquippedItemsBack_tooltip")
    )
    self.options.DropEquippedItemsConatiner = options:addTickBox(
        "DropEquippedItemsConatiner",
        getText("UI_TABAS_DropEquippedItemsConatiner"),
        true,
        getText("UI_TABAS_DropEquippedItemsConatiner_tooltip")
    )
    self.options.DropEquippedItemsAttached = options:addTickBox(
        "DropEquippedItemsAttached",
        getText("UI_TABAS_DropEquippedItemsAttached"),
        false,
        getText("UI_TABAS_DropEquippedItemsAttached_tooltip")
    )
    self.options.DropEquippedItemsHand = options:addTickBox(
        "DropEquippedItemsHand",
        getText("UI_TABAS_DropEquippedItemsHand"),
        false,
        getText("UI_TABAS_DropEquippedItemsHand_tooltip")
    )
    self.options.DropEquippedItemsClothing = options:addTickBox(
        "DropEquippedItemsClothing",
        getText("UI_TABAS_DropEquippedItemsClothing"),
        false,
        getText("UI_TABAS_DropEquippedItemsClothing_tooltip")
    )
    self.options.DropEquippedItemsWeight = options:addSlider(
        "DropEquippedItemsWeight",
        getText("UI_TABAS_DropEquippedItemsWeight"),
        0, 10, 0.1, 4,
        getText("UI_TABAS_DropEquippedItemsWeight_tooltip")
    )
end

Events.OnGameBoot.Add(function() TABAS_ModOptions:createOptions() end)

return TABAS_ModOptions.options